<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Recevoir mon invitation</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />

  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />

  <style>
    body {
      background: #f7f9fc;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      padding: 2rem 1rem;
    }
    /* On supprime la div invitation car la génération se fait sur une autre page */
  </style>
</head>
<body>

  <div class="container" style="max-width: 500px;">
    <h1 class="mb-4 text-center text-primary">Recevoir mon invitation</h1>

    <!-- FORMULAIRE POST vers invitation_process.php -->
    <form id="invitationForm" method="POST" action="invitation_process.php" novalidate>
      <div class="mb-3">
        <label for="fullName" class="form-label">Nom complet <span class="text-danger">*</span></label>
        <input name="fullName" type="text" class="form-control" id="fullName" required />
        <div class="invalid-feedback">Merci de saisir votre nom complet.</div>
      </div>

      <div class="mb-3">
        <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
        <input name="email" type="email" class="form-control" id="email" required />
        <div class="invalid-feedback">Merci de saisir un email valide.</div>
      </div>

      <div class="mb-3">
        <label for="phone" class="form-label">Téléphone (facultatif)</label>
        <input name="phone" type="tel" class="form-control" id="phone" pattern="^[0-9+ ]*$" />
        <div class="invalid-feedback">Merci de saisir un numéro valide.</div>
      </div>

      <div class="mb-3">
        <label for="codeRef" class="form-label">Code ou référence (si invitation ciblée)</label>
        <input name="codeRef" type="text" class="form-control" id="codeRef" />
      </div>

      <button type="submit" class="btn btn-primary w-100">Générer mon QR Code</button>
    </form>

  </div>

  <!-- Bootstrap JS Bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    // Validation HTML5 native avec Bootstrap
    (() => {
      'use strict'
      const forms = document.querySelectorAll('#invitationForm')
      Array.from(forms).forEach(form => {
        form.addEventListener('submit', event => {
          if (!form.checkValidity()) {
            event.preventDefault()
            event.stopPropagation()
          }
          form.classList.add('was-validated')
        }, false)
      })
    })()
  </script>
</body>
</html>
